﻿//NINA.jsx
// Więcej informacji o kształtach NINA znaleźć można na stronie:
//http://www.washington.edu/bibsys/mattf/nina/index.html
if(app.documents.length != 0){
if(app.activeWindow.constructor.name == "LayoutWindow"){
var myViewPreferences = app.activeDocument.viewPreferences;
var myOldXUnits = myViewPreferences.horizontalMeasurementUnits;
var myOldYUnits = myViewPreferences.verticalMeasurementUnits;
app.activeDocument.viewPreferences.horizontalMeasurementUnits =
MeasurementUnits.points;
app.activeDocument.viewPreferences.verticalMeasurementUnits =
MeasurementUnits.points;
myDisplayDialog();
app.activeDocument.viewPreferences.horizontalMeasurementUnits =
myOldXUnits;
app.activeDocument.viewPreferences.verticalMeasurementUnits =
myOldYUnits;
}
}
function myDrawNina(myNumberOfLines, a_pulse, b_pulse, myLength,
myClosedPath){
var cur_x, cur_y;
var myAnchor = new Array(2);
var myArray = new Array;
// Zamiast rysować całą ścieżkę punkt po punkcie,
// utworzymy tablicę zawierającą współrzędne punktów
// za pomocą właściwości entirePath.
for (var myCounter = 0; myCounter < myNumberOfLines; myCounter++){
cur_x = (Math.cos((-2 * Math.PI * a_pulse * myCounter) /
myNumberOfLines) + Math.cos((-2 * Math.PI * b_pulse * myCounter)
/ myNumberOfLines)) * myLength;
cur_y = (Math.sin((-2 * Math.PI * a_pulse * myCounter) /
myNumberOfLines) + Math.sin((-2 * Math.PI * b_pulse * myCounter)
/ myNumberOfLines)) * myLength;
myAnchor = [cur_x, cur_y];
myArray.push(myAnchor);
}
app.activeDocument.viewPreferences.horizontalMeasurementUnits =
MeasurementUnits.points;
app.activeDocument.viewPreferences.verticalMeasurementUnits =
MeasurementUnits.points;
var myPage = app.activeWindow.activePage;
var myGraphicLine = myPage.graphicLines.add();
myGraphicLine.move(undefined, ["1p","1p"]);
var myPath = myGraphicLine.paths.item(0);
//Tworzymy ścieżkę w oparciu o zawartość tablicy
myPath.entirePath = myArray;
if(myClosedPath == true){
myPath.pathType = PathType.closedPath;
}
else{
myPath.pathType = PathType.openPath;
}
//Label the graphic line with the parameters used to create it.
//Dodajemy etykiete (opis)  ustawień wykorzystanych do utworzenia grafiki.
myGraphicLine.label = "number_of_lines = " + myNumberOfLines + 
", a_pulse = " + a_pulse + ", b_pulse = " + b_pulse;
}
function myDisplayDialog(){
var myDialog = app.dialogs.add({name:"NINA"});
with(myDialog){
//Dodajemy kolumnę okna dialogowego
myDialogColumn = dialogColumns.add()
with(myDialogColumn){
with(borderPanels.add()){
with(dialogColumns.add()){
staticTexts.add({staticLabel:"Number of iterations:"}) ;
staticTexts.add({staticLabel:"a_pulse:"});
staticTexts.add({staticLabel:"b_pulse:"});
staticTexts.add({staticLabel:"Line length (in points):"});
}
with(dialogColumns.add()){
// Poniższy wiersz prezentuje definiowanie wielu właściwości tworzonego obiektu.
// Parametry 201:16:161:72 pozwalają utworzyć ładny kształt NINA
myNumberOfLinesField = integerEditboxes.add({editValue:201,
minWidth:60});
myAPulseField = integerEditboxes.add({editValue:16,
minWidth:60});
myBPulseField = integerEditboxes.add({editValue:161,
minWidth:60});
myLengthField = integerEditboxes.add({editValue:72,
minWidth:60});
}
}
with(borderPanels.add()){
with(radiobuttonGroups.add()){
myClosedPathButton = radiobuttonControls.add(
{staticLabel:"Closed path", checkedState:true});
myOpenPathButton = radiobuttonControls.add({staticLabel:
"Open path"});
}
}
}
}
myReturn = myDialog.show();
if (myReturn == true){
//Pobieramy wartości z pól okna dialogowego
myNumberOfLines = myNumberOfLinesField.editValue;
a_pulse = myAPulseField.editValue;
b_pulse = myBPulseField.editValue;
myLength = myLengthField.editValue;
myClosedPath = myClosedPathButton.checkedState;
myDialog.destroy();
myDrawNina(myNumberOfLines, a_pulse, b_pulse, myLength,
myClosedPath);
}
else{
myDialog.destroy();
}
}